/* 
*	ֲWatcomC++,1999414
*
*/

#include <string.h>
#include <malloc.h>
#include "gl.h"

ScreenInfo screenInfo = { 640, 480, 16 };
DWORD colorMask[6];
DWORD rbMask, gMask;
extern DWORD rbMask, gMask;
extern DWORD colorMask[6];

int InitGraphicLibrary( int colorDepth )
{
	if( colorDepth == 15 ){
		colorMask[0] = colorMask[1] = 0x7c007c00;
		colorMask[2] = colorMask[3] = 0x03e003e0;
		colorMask[4] = colorMask[5] = 0x001f001f;
		rbMask = 0x7c1f;
		gMask = 0x03e0;
		screenInfo.colorDepth = 15;
	}
	else if( colorDepth == 16 ){
		colorMask[0] = colorMask[1] = 0xf800f800;
		colorMask[2] = colorMask[3] = 0x07e007e0;
		colorMask[4] = colorMask[5] = 0x001f001f;
		rbMask = 0xf81f;
		gMask = 0x03e0;
		screenInfo.colorDepth = 16;
	}
	else 
		return -1;

	return 0;
}

Bitmap* CreateBitmap( int w,  int h )
{
	return CreateBitmapEx( w, h, screenInfo.colorDepth );
}

Bitmap* CreateBitmapEx( int w, int h, int colorDepth )
{
	Bitmap* bmp;
	
	switch( colorDepth ){
	case 8:
		bmp = new Bitmap8;
		if( bmp )
			bmp->colorKey = COLORKEY8;
		break;
		
	case 15:
		bmp = new Bitmap15;
		if( bmp )
			bmp->colorKey = COLORKEY15;
		break;
		
	case 16:
/*		if( cpu.mmx ) bmp = new Bitmap16MMX;
		else*/ bmp = new Bitmap16;
		if( bmp )
			bmp->colorKey = COLORKEY16;
		break;
		
	case 24:	
		bmp = new Bitmap24;
		if( bmp )
			bmp->colorKey = COLORKEY24;
		break;
	
	case 32:
		bmp = new Bitmap32;
		if( bmp )
			bmp->colorKey = COLORKEY32;
		break;
			
	default:
		return NULL;
	}
	
	if( bmp == NULL ) 
		return NULL;
	
	if( w % 2 )	// ȵΪż
		w ++;
	bmp->dat = new char[ w * h * BYTES_PER_PIXEL( colorDepth ) + 8 ];	// add 8 for align at 8 bytes
	if( bmp->dat == NULL ){
		delete bmp;
		return NULL;
	}

	bmp->line = (char**)new char[ h * sizeof( char * )];
	if( bmp->line == NULL ){
		delete bmp;
		return NULL;
	}

	// ֽڶ
	if( (DWORD)bmp->dat & 0x7 != 0 )
		bmp->line[0] = ( char* )((( DWORD )bmp->dat + 8 ) & 0xfffffff8 );
	else
		bmp->line[0] = (char*)bmp->dat;
	for( int i=1; i<h; i++ ){
		bmp->line[ i ] = bmp->line[ i-1 ] + w * BYTES_PER_PIXEL( colorDepth );
	}

	bmp->width = bmp->cr = w;	
	bmp->height = bmp->cb = h;
	bmp->colorDepth = colorDepth;
	bmp->clip = true;
	bmp->cl = bmp->ct = 0;
	bmp->pitch = w * BYTES_PER_PIXEL( colorDepth );

	return bmp;
}
//Ӵ̶ͼ,convertΪ1,ʽתĸʽ
//֧tga,bmpļʽ
Bitmap* LoadPicture( char* filename, int convert, Palette* pal )
{
	Bitmap *temp;
	if( filename == NULL )
		return NULL;

	char *p = filename + strlen( filename ) - 4;
	if( stricmp( p, ".tga" ) == 0 )
		temp = LoadTga( filename, pal );
	else if( stricmp( p, ".bmp" ) == 0 )
		temp = LoadBmp( filename, pal );
	else
		return NULL;

	if( temp && convert )
		temp = temp->ConvertFormat( screenInfo.colorDepth );

	return temp;
}

int Bitmap::drawMode = Bitmap::SolidMode;
int Bitmap::alpha = 255;

Bitmap::Bitmap( )
{
	dat = NULL;
	line = NULL;
	clip = false;
	color = 0;
	colorKey = 0;
}

void Bitmap::SetClip( int l, int t, int r, int b )
{
	clip = true;
	int temp;
	if( l > r ){
		temp = l;
		l = r;
		r = temp;
	}
	if( b < t ){
		temp = t;
		t = b;
		b = temp;
	}
	cl = l;
	if( l < 0 )
		cl = 0;
	ct = t;
	if( t < 0 ) 
		ct = 0;
	cr = r;
	if( r > width )
		cr = width;
	cb = b;
	if( b > height )
		cb = height;
}

void Bitmap::SetClip( int enable )
{
	clip = ( enable ) ? true : false;
}

void Bitmap::SetDrawMode( int drawmode, int alpha )
{
	if( drawmode & SolidMode )
		drawMode = SolidMode;
	else if( drawmode & XorMode )
		drawMode = XorMode;
	else if( drawmode & AlphaMode ){
		drawMode = AlphaMode;
		Bitmap::alpha = alpha;
	}
}
/////////////////////////////////////////////////////////////////////

Palette::Palette()
{
	count = 0;
	memset( palette, 0, sizeof( ColorEntry )*PAL_SIZE );
}

void Palette::AddRef( void )
{
	count ++;
}

void Palette::Release( void )
{
	count --;
}

void Palette::Destroy( void )
{
	if( count == 0 )
		delete this;
}

void Palette::Convert( void )
{
	int i;
	
	switch( screenInfo.colorDepth ){
	case 8:
		memcpy( screenPal, palette, PAL_SIZE * sizeof( DWORD ));
		break;
		
	case 15:
		for( i=0; i<PAL_SIZE; i++ ){
			screenPal[i] = (( palette[i].rgbRed & 0xf8 ) << 7 )
					| (( palette[i].rgbGreen & 0xf8 ) << 2 )
					| ( palette[i].rgbBlue >> 3 );
		}
		break;
		
	case 16:
		for( i=0; i<PAL_SIZE; i++ ){
			screenPal[i] = ((( short )palette[i].rgbRed & 0xf8 ) << 8 )
					| ((( short )palette[i].rgbGreen & 0xfc ) << 3 )
					| (( short )palette[i].rgbBlue >> 3 );
		}
		break;
		
	case 24:
	case 32:
		for( i=0; i<PAL_SIZE; i++ ){
			screenPal[i] = palette[i].rgb & 0xffffff;
		}
	break;
	}
}

void Palette::WriteToDisk( FILE *fp, int num )
{
	for( int i=0; i<num; i++ ){
		fwrite( &palette[i].rgb, 4, 1, fp );
	}
}

void Palette::ReadFromDisk( FILE *fp, int num )
{
	for( int i=0; i<num; i++ ){
		fread( &palette[i].rgb, 4, 1, fp );
	}
}
